/*******************************************************
	Author: 
		Liu Caiquan
	Date: 
		@8th-December-2016@

	CarLife Protocol version:
		@V1.2.4@
							Copyright (C) Under BaiDu, Inc.
*******************************************************/
#include "CConnectionSetupModule.h"
#include "CConnectManager.h"
#include "CCarLifeLog.h"
// all the logging messages in this file are replaced to DLT by ADIT
LOG_IMPORT_CONTEXT(bdcl_core) //added by ADIT

using namespace std;

CConnectionSetupModule* CConnectionSetupModule::pInstance;

CConnectionSetupModule::CConnectionSetupModule(){
	CConnectionSetupModule::pInstance=NULL;
}


CConnectionSetupModule::~CConnectionSetupModule(){ // added by ADIT
  pInstance = NULL;
}



CConnectionSetupModule* CConnectionSetupModule::getInstance(){
	if(NULL==pInstance){
		pInstance= new CConnectionSetupModule();
		}

	return pInstance;
}

//modified by ADIT
int CConnectionSetupModule::connectionSetup(){
	//adb forward for video, media, tts, vr, touch channels
	CConnectManager::getInstance()->execSocketForward();

	//create socket for channels
	if(CConnectManager::getInstance()->createCmdSocket()){
		LOGD_DEBUG((bdcl_core,"cmd channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"cmd channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createVideoSocket()){
		LOGD_DEBUG((bdcl_core,"video channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"video channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createMediaSocket()){
		LOGD_DEBUG((bdcl_core,"media channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"media channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createTTSSocket()){
		LOGD_DEBUG((bdcl_core,"tts channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"tts channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createVRSocket()){
		LOGD_DEBUG((bdcl_core,"vr channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"vr channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createTouchSocket()){
		LOGD_DEBUG((bdcl_core,"ctrl channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"ctrl channel socket create failed!"));
		return -1;
			}

	return 0;
}

int CConnectionSetupModule::connectionSetup(int accOrWrId, int devOrRdId, deviceType inDevice){ //Modified by ADIT
//ADIT modified

	if (CConnectManager::getInstance()->createProtocolConnector(accOrWrId, devOrRdId, inDevice)) { //.Modified by ADIT
	    LOG_INFO((bdcl_core,"protocol connector create successfully!"));
	} else {
	    LOG_ERROR((bdcl_core,"protocol connector create failed!"));

	}

	//create socket for channels
	if(CConnectManager::getInstance()->createCmdSocket()){
		LOGD_DEBUG((bdcl_core,"cmd channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"cmd channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createVideoSocket()){
		LOGD_DEBUG((bdcl_core,"video channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"video channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createMediaSocket()){
		LOGD_DEBUG((bdcl_core,"media channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"media channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createTTSSocket()){
		LOGD_DEBUG((bdcl_core,"tts channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"tts channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createVRSocket()){
		LOGD_DEBUG((bdcl_core,"vr channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"vr channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createTouchSocket()){
		LOGD_DEBUG((bdcl_core,"ctrl channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"ctrl channel socket create failed!"));
		return -1;
			}

	return 0;
}

int CConnectionSetupModule::connectionSetup(string mdIPAddress){
	//create socket for channels
	if(CConnectManager::getInstance()->createCmdSocket(mdIPAddress)){
		LOGD_DEBUG((bdcl_core,"cmd channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"cmd channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createVideoSocket(mdIPAddress)){
		LOGD_DEBUG((bdcl_core,"video channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"video channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createMediaSocket(mdIPAddress)){
		LOGD_DEBUG((bdcl_core,"media channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"media channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createTTSSocket(mdIPAddress)){
		LOGD_DEBUG((bdcl_core,"tts channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"tts channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createVRSocket(mdIPAddress)){
		LOGD_DEBUG((bdcl_core,"vr channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"vr channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createTouchSocket(mdIPAddress)){
		LOGD_DEBUG((bdcl_core,"ctrl channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"ctrl channel socket create failed!"));
		return -1;
			}

	return 0;
}

int CConnectionSetupModule::connectionSetup(string mdIPAddress, string interfaceName){
	//create socket for channels
	if(CConnectManager::getInstance()->createCmdSocket(mdIPAddress, interfaceName)){
		LOGD_DEBUG((bdcl_core,"cmd channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"cmd channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createVideoSocket(mdIPAddress, interfaceName)){
		LOGD_DEBUG((bdcl_core,"video channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"video channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createMediaSocket(mdIPAddress, interfaceName)){
		LOGD_DEBUG((bdcl_core,"media channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"media channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createTTSSocket(mdIPAddress, interfaceName)){
		LOGD_DEBUG((bdcl_core,"tts channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"tts channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createVRSocket(mdIPAddress, interfaceName)){
		LOGD_DEBUG((bdcl_core,"vr channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"vr channel socket create failed!"));
		return -1;
			}
	if(CConnectManager::getInstance()->createTouchSocket(mdIPAddress, interfaceName)){
		LOGD_DEBUG((bdcl_core,"ctrl channel socket create successfully!"));
		}else{
		LOG_ERROR((bdcl_core,"ctrl channel socket create failed!"));
		return -1;
			}

	return 0;
}




































